<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van RCMR_IN010027NL -  Retrieve Consents Query Response</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <include href="APF/RCMR_MT010001NL.sch"/>

    <pattern is-a="attentionLine" id="RCMR_IN010027NL-attentionLine">
        <param name="messagePatientId"
            value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:consentDirective/hl7:subject/hl7:patient/hl7:id"/>
        <param name="attentionLineOptional" value="'true'"/>
    </pattern>
    
    <pattern is-a="transmission-wrapper" id="RCMR_IN010027NL-wrapper">
        <param name="element" value="hl7:RCMR_IN010027NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="RCMR_IN010027NL-controlAct">
        <param name="element" value="hl7:RCMR_IN010027NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:RCMR_IN010027NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:RCMR_IN010027NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:RCMR_IN010027NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- zender -->
        <rule context="hl7:RCMR_IN010027NL/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >Zender moet de ZIM zijn.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>registrationProcess</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess">
            <assert role="error" test="hl7:id">registrationProcess/id is verplicht in het antwoord van de ZIM</assert>
            <assert role="error" test="hl7:effectiveTime">registrationProcess/effectiveTime is verplicht in het antwoord van de ZIM</assert>
        </rule>

        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:code">
            <assert role="error" test="@code='116116' and @codeSystem='2.16.840.1.113883.2.4.15.4'">registrationProcess/code moet '116116' zijn uit codeSystem
                '2.16.840.1.113883.2.4.15.4'</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:statusCode">
            <assert role="error" test="@code='active' or @code='obsolete'">registrationProcess/statusCode moet 'active' of 'obsolete' zijn</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:effectiveTime">
            <assert role="error" test="hl7:low and string-length(hl7:low/@value) &gt;= 8">registrationProcess/effectiveTime/low moet tenminste tot op de dag
                precies zijn</assert>
            <assert role="error" test="not(hl7:high) or (hl7:high and string-length(hl7:high/@value) &gt;= 8)">registrationProcess/effectiveTime/high moet
                tenminste tot op de dag precies zijn</assert>
            <assert role="error"
                test="number(substring(hl7:low/@value,1,8)) &gt;= number(substring(../hl7:subject2/hl7:consentDirective/hl7:effectiveTime/hl7:low/@value,1,8))"
                >registrationProcess/effectiveTime datum '<value-of select="substring(hl7:low/@value,1,8)"/>' moet gelijk zijn of liggen na de datum
                    '<value-of select="substring(../hl7:subject2/hl7:consentDirective/hl7:effectiveTime/hl7:low/@value,1,8)"/>' van
                subject2/consentDirective</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess">
            <assert role="error" test="count(hl7:subject2) = 1">registrationProcess moet precies één autorisatieprofiel bevatten.</assert>
        </rule>
    </pattern>

    <pattern>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:consentDirective">
            <assert role="error" test="hl7:id">RCMR_MT010001NL: consentDirective/id is verplicht in acceptatie berichten verstuurd door de ZIM</assert>
        </rule>
    </pattern>

    <pattern is-a="RCMR_MT010001" id="RCMR_IN010027NL-RCMR_MT010001">
        <param name="element" value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:consentDirective"/>
    </pattern>

</schema>
